#include "Rinternals.h"
#include "R_ext/Rdynload.h"

static void addone(double *x, int *nx, double *val, int *nv)
{
    if (nx[0] == nv[0]) {
	int n, i;

	n = nx[0];
	for (i = 0; i < n; i++)
	    val[i] = x[i] + 1.0;
    }
    else error("argument and value lengths do not match.");
}

/* This defines a data structure for registering the routine
   `addone'. It records the number of arguments, which allows some
   error checking when the routine is called. */
static R_CMethodDef DotCEntries[] = {
    {"add_one", (DL_FUNC) addone, 4},
    {NULL}
};

/* This is called by the dynamic loader to register the routine. */
void R_init_AddOne(DllInfo *info)
{
    R_registerRoutines(info, DotCEntries, NULL, NULL, NULL);
    R_useDynamicSymbols(info, FALSE);
}
