/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import rvl.awt.Plot;

public class IntPlot
extends Plot
implements MouseListener,
MouseMotionListener {
    private transient ActionListener actionListener = null;
    private boolean isMoving = false;
    private boolean enableMoves = true;
    private boolean constrainX = false;
    private boolean constrainY = false;
    private int[] index;
    private double[] point;
    private Cursor finger = Cursor.getPredefinedCursor(12);
    private Cursor pointer = Cursor.getDefaultCursor();

    public IntPlot(double[][] dArray, double[][] dArray2) {
        super(dArray, dArray2);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public IntPlot(double[] dArray, double[] dArray2) {
        this(new double[][]{dArray}, (double[][])new double[][]{dArray2});
    }

    public IntPlot(double[] dArray, double[][] dArray2) {
        this(new double[][]{dArray}, dArray2);
    }

    public void setMoveable(boolean bl) {
        this.enableMoves = bl;
        this.isMoving = false;
    }

    public boolean isMoveable() {
        return this.enableMoves;
    }

    public void setConstraints(boolean bl, boolean bl2) {
        this.constrainX = bl;
        this.constrainY = bl2;
        this.enableMoves = !(bl & bl2);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        Image image = this.createImage(dimension.width, dimension.height);
        Graphics graphics2 = image.getGraphics();
        super.paint(graphics2);
        graphics2.dispose();
        graphics.drawImage(image, 0, 0, this);
    }

    protected int[] locate(int n, int n2, int n3) {
        double[][] dArray = this.swap ? this.y : this.x;
        double[][] dArray2 = this.swap ? this.x : this.y;
        double d = this.hMin + ((double)n - this.h0) / this.mh;
        double d2 = this.vMax - ((double)n2 - this.v0) / this.mv;
        double d3 = (double)n3 / this.mh;
        double d4 = (double)n3 / this.mv;
        int n4 = dArray.length;
        int n5 = dArray2.length;
        int n6 = Math.max(n4, n5);
        for (int i = 0; i < n6; ++i) {
            int n7 = i % n4;
            int n8 = i % n5;
            double[] dArray3 = dArray[n7];
            double[] dArray4 = dArray2[n8];
            int n9 = dArray3.length;
            int n10 = dArray4.length;
            int n11 = Math.max(n9, n10);
            for (int j = 0; j < n11; ++j) {
                int[] nArray;
                int n12 = j % n9;
                int n13 = j % n10;
                if (!(Math.abs(d - dArray3[n12]) < d3) || !(Math.abs(d2 - dArray4[n13]) < d4)) continue;
                if (this.swap) {
                    int[] nArray2 = new int[4];
                    nArray2[0] = n13;
                    nArray2[1] = n8;
                    nArray2[2] = n12;
                    nArray = nArray2;
                    nArray2[3] = n7;
                } else {
                    int[] nArray3 = new int[4];
                    nArray3[0] = n12;
                    nArray3[1] = n7;
                    nArray3[2] = n13;
                    nArray = nArray3;
                    nArray3[3] = n8;
                }
                return nArray;
            }
        }
        return null;
    }

    private void doAction(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.enableMoves) {
            return;
        }
        this.index = this.locate(mouseEvent.getX(), mouseEvent.getY(), 5);
        if (this.index == null) {
            return;
        }
        this.point = new double[]{this.x[this.index[1]][this.index[0]], this.y[this.index[3]][this.index[2]]};
        this.isMoving = true;
        this.setCursor(this.finger);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCursor(this.pointer);
        this.isMoving = false;
        this.needsRescaling = true;
        this.doAction("IntPlot");
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isMoving) {
            return;
        }
        double d = this.hMin + ((double)mouseEvent.getX() - this.h0) / this.mh;
        double d2 = this.vMax - ((double)mouseEvent.getY() - this.v0) / this.mv;
        boolean bl = this.needsRescaling = d < this.hMin || d > this.hMax || d2 < this.vMin || d2 > this.vMax;
        if (this.swap) {
            if (!this.constrainX) {
                this.x[this.index[1]][this.index[0]] = d2;
            }
            if (!this.constrainY) {
                this.y[this.index[3]][this.index[2]] = d;
            }
        } else {
            if (!this.constrainX) {
                this.x[this.index[1]][this.index[0]] = d;
            }
            if (!this.constrainY) {
                this.y[this.index[3]][this.index[2]] = d2;
            }
        }
        this.update(this.getGraphics());
    }
}

