/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import rvl.awt.RVLayout;
import rvl.piface.ActionComponent;
import rvl.util.Utility;

public class PiArrayField
extends Panel
implements ActionComponent,
KeyListener {
    private String name;
    private String label;
    private Font font = new Font("Serif", 1, 12);
    private TextField field;
    private transient ActionListener actionListener = null;

    public PiArrayField(String string, String string2, double[] dArray) {
        this(string, string2, dArray, 12);
    }

    public PiArrayField(String string, String string2, double[] dArray, int n) {
        this.setName(string, string2);
        this.setLayout(new RVLayout(2, false, true));
        Label label = new Label(string2);
        label.setFont(this.font);
        this.add(label);
        this.field = new TextField(n);
        this.setValue(dArray);
        this.add(this.field);
        this.field.addKeyListener(this);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setName(String string, String string2) {
        this.name = string;
        this.label = string2;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public double[] getValue() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.field.getText(), " ,\t");
        int n = stringTokenizer.countTokens();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            String string = stringTokenizer.nextToken();
            dArray[i] = Utility.strtod(string);
        }
        return dArray;
    }

    public void setValue(double[] dArray) {
        String string = "";
        for (int i = 0; i < dArray.length; ++i) {
            string = string + Utility.format(dArray[i], 3) + " ";
        }
        this.field.setText(string);
    }

    public void setEditable(boolean bl) {
        this.field.setEditable(bl);
    }

    public boolean isEditable() {
        return this.field.isEditable();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.field.setBackground(this.field.isEditable() ? Color.white : color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.field.setForeground(color);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 10) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, "" + this.toString());
        this.actionListener.actionPerformed(actionEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

