/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import java.awt.Color;
import java.awt.Component;
import rvl.piface.PiComponent;
import rvl.piface.Piface;
import rvl.piface.PifaceAux;
import rvl.stat.dist.T;

public class TwoTFlex
extends Piface {
    private static String title = "Two-sample t test (general case)";
    private PiComponent threshField;
    public double sigma1;
    public double sigma2;
    public double n1;
    public double n2;
    public double diff;
    public double thresh;
    public double alpha;
    public double df;
    public double power;
    public double v1;
    public double v2;
    public double delta;
    public double mult;
    public double saveN1;
    public double saveN2;
    public int eqs;
    public int alloc;
    public int tt;
    public int prevTT;
    public int opt;
    public int equiv;
    static /* synthetic */ Class class$rvl$piface$apps$AnovaPicker;

    public void gui() {
        this.setBackground(new Color(230, 230, 230));
        this.beginSubpanel(1, Color.blue.darker());
        this.bar("sigma1", 1.0);
        this.bar("sigma2", 1.0);
        this.checkbox("eqs", "Equal sigmas", 1);
        this.endSubpanel();
        this.filler();
        this.beginSubpanel(1, Color.blue.darker());
        this.bar("n1", 25.0);
        this.bar("n2", 25.0);
        this.choice("alloc", "Allocation", new String[]{"Independent", "Equal", "Optimal"}, 1);
        this.endSubpanel();
        this.newColumn();
        this.ofield("df", "Degrees of freedom", this.n1 + this.n2 - 2.0);
        this.beginSubpanel(2);
        this.checkbox("tt", "Two-tailed", 1);
        this.choice("alpha", new double[]{0.005, 0.01, 0.02, 0.05, 0.1, 0.2}, 3);
        this.checkbox("equiv", "Equivalence", 0);
        this.field("thresh", "Threshhold", 1.0);
        this.endSubpanel();
        this.filler();
        this.bar("diff", "True difference of means", 0.5);
        this.beginSubpanel(1, Color.blue.darker());
        this.interval("power", 0.5, 0.0, 1.0);
        this.choice("opt", "Solve for", new String[]{"Sample size", "Diff of means"}, 0);
        this.endSubpanel();
        this.threshField = this.getComponent("thresh");
        this.prevTT = this.tt;
        this.equiv_changed();
        this.menuItem("localHelp", "t test info", this.helpMenu);
    }

    public void click() {
        this.n1 = TwoTFlex.max(2.0, TwoTFlex.round(this.n1));
        if (this.eqs == 1) {
            this.sigma2 = this.sigma1;
        }
        if (this.eqs == 1 || this.alloc == 1) {
            this.n2 = this.n1;
        } else if (this.alloc == 2) {
            this.n2 = TwoTFlex.max(2.0, TwoTFlex.round(this.n1 * this.sigma2 / this.sigma1));
        }
        this.sattPower();
    }

    public void sigma2_changed() {
        if (this.eqs == 1) {
            this.sigma1 = this.sigma2;
        }
        if (this.alloc == 2) {
            this.n2 = TwoTFlex.max(2.0, TwoTFlex.round(this.n1 * this.sigma2 / this.sigma1));
        }
        this.sattPower();
    }

    public void n2_changed() {
        this.n2 = TwoTFlex.max(2.0, TwoTFlex.round(this.n2));
        if (this.eqs == 1 || this.alloc == 1) {
            this.n1 = this.n2;
        } else if (this.alloc == 2) {
            this.n1 = TwoTFlex.max(2.0, TwoTFlex.round(this.n2 * this.sigma1 / this.sigma2));
        }
        this.sattPower();
    }

    public void sattPower() {
        this.v1 = this.sigma1 * this.sigma1 / this.n1;
        this.v2 = this.sigma2 * this.sigma2 / this.n2;
        double d = TwoTFlex.sqrt(this.v1 + this.v2);
        this.delta = this.diff / d;
        this.df = (this.v1 + this.v2) * (this.v1 + this.v2) / (this.v1 * this.v1 / (this.n1 - 1.0) + this.v2 * this.v2 / (this.n2 - 1.0));
        this.power = this.equiv == 0 ? T.power(this.delta, this.df, 1 - this.tt, this.alpha) : T.powerEquiv(this.diff, this.thresh, d, this.df, this.alpha);
    }

    public void power_changed() {
        if (this.equiv == 1) {
            this.power_changed_equiv();
            return;
        }
        switch (this.opt) {
            case 0: {
                double d = this.power;
                this.diff = TwoTFlex.max(this.diff, 0.01 * (this.sigma1 + this.sigma2));
                for (int i = 0; i < 3; ++i) {
                    this.delta = T.delta(d, this.df, 1 - this.tt, this.alpha);
                    this.mult = (this.v1 + this.v2) * this.delta * this.delta / this.diff / this.diff;
                    this.n1 *= this.mult;
                    this.n2 *= this.mult;
                    this.sattPower();
                }
                this.n1 = TwoTFlex.max(TwoTFlex.round(this.n1), 2.0);
                this.n2 = TwoTFlex.max(TwoTFlex.round(this.n2), 2.0);
                this.sattPower();
                break;
            }
            case 1: {
                this.delta = T.delta(this.power, this.df, 1 - this.tt, this.alpha);
                this.diff = this.delta * TwoTFlex.sqrt(this.v1 + this.v2);
                this.sattPower();
            }
        }
    }

    public void power_changed_equiv() {
        switch (this.opt) {
            case 0: {
                this.saveN1 = this.n1;
                this.saveN2 = this.n2;
                PifaceAux pifaceAux = new PifaceAux("mult", "power", this);
                pifaceAux.xMin = TwoTFlex.max(2.0 / this.n1, 2.0 / this.n2);
                pifaceAux.closedMin = true;
                pifaceAux.xeps = TwoTFlex.max(0.5 / this.n1, 0.5 / this.n2);
                this.mult = this.solve(pifaceAux, this.power, 1.0, 0.1);
                this.n1 = TwoTFlex.max(TwoTFlex.round(this.n1 * this.mult), 2.0);
                this.n2 = TwoTFlex.max(TwoTFlex.round(this.n2 * this.mult), 2.0);
                break;
            }
            case 1: {
                PifaceAux pifaceAux = new PifaceAux("diff", "power", this);
                pifaceAux.xeps = 0.005 * (this.sigma1 + this.sigma2);
                this.diff = Math.max(this.diff, 0.1 * (this.sigma1 + this.sigma2));
                this.diff = this.solve(pifaceAux, this.power, this.diff, 0.1 * this.diff);
            }
        }
        this.sattPower();
    }

    public void mult_changed() {
        this.n1 = this.saveN1 * this.mult;
        this.n2 = this.saveN2 * this.mult;
        this.sattPower();
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$AnovaPicker == null ? (class$rvl$piface$apps$AnovaPicker = TwoTFlex.class$("rvl.piface.apps.AnovaPicker")) : class$rvl$piface$apps$AnovaPicker, "TwoTFlexHelp.txt", "Power analysis help: Two-sample t test", 25, 60);
    }

    public void equiv_changed() {
        ((Component)((Object)this.threshField)).setVisible(this.equiv == 1);
        if (this.equiv == 1) {
            this.prevTT = this.tt;
            this.tt = 1;
        } else {
            this.tt = this.prevTT;
        }
        this.sattPower();
    }

    public TwoTFlex() {
        super(title);
    }

    public static void main(String[] stringArray) {
        new TwoTFlex();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

