/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.dist;

import rvl.stat.dist.Beta;
import rvl.stat.dist.BinomialAux;
import rvl.stat.dist.Normal;
import rvl.util.Solve;
import rvl.util.Utility;

public class Binomial {
    public static double cdf(int n, int n2, double d) {
        if (d < 0.0 || d > 1.0) {
            Utility.warning("Binomial.cdf: p must be in [0,1]");
            return 2.147483647E9;
        }
        if (n < 0) {
            return 0.0;
        }
        if (n >= n2) {
            return 1.0;
        }
        return Beta.cdf(1.0 - d, 0.0 + (double)n2 - (double)n, (double)n + 1.0);
    }

    public static int quantile(double d, int n, double d2) {
        if (d < 0.0 || d > 1.0) {
            Utility.warning("Binomial.quantile: alpha must be in [0,1]");
            return Integer.MAX_VALUE;
        }
        if (d2 < 0.0 || d2 > 1.0) {
            Utility.warning("Binomial.quantile: p must be in [0,1]");
            return Integer.MAX_VALUE;
        }
        int n2 = (int)((double)n * d2 + Normal.quantile(d) * Math.sqrt((double)n * d2 * (1.0 - d2)));
        double d3 = Binomial.cdf(n2 = Math.max(-1, Math.min(n, n2)), n, d2);
        if (d3 < d) {
            while ((d3 = Binomial.cdf(++n2, n, d2)) < d - 1.0E-6) {
            }
            --n2;
        } else if (d3 > d) {
            while ((d3 = Binomial.cdf(--n2, n, d2)) > d + 1.0E-6) {
            }
        }
        return n2;
    }

    public static double[] power(double d, double d2, int n, int n2, double d3) {
        double d4;
        double d5;
        if (n2 < 0) {
            int n3 = Binomial.quantile(d3, n, d);
            d5 = Binomial.cdf(n3, n, d);
            d4 = Binomial.cdf(n3, n, d2);
        } else if (n2 == 0) {
            int n4 = Binomial.quantile(d3 / 2.0, n, d);
            d5 = Binomial.cdf(n4, n, d);
            d4 = Binomial.cdf(n4, n, d2);
            n4 = 1 + Binomial.quantile(1.0 - d3 / 2.0, n, d);
            d5 += 1.0 - Binomial.cdf(n4, n, d);
            d4 += 1.0 - Binomial.cdf(n4, n, d2);
        } else {
            int n5 = 1 + Binomial.quantile(1.0 - d3, n, d);
            d5 = 1.0 - Binomial.cdf(n5, n, d);
            d4 = 1.0 - Binomial.cdf(n5, n, d2);
        }
        return new double[]{d4, d5};
    }

    public static double[] waldPower(double d, double d2, int n, int n2, double d3) {
        int n3;
        double d4;
        double d5;
        double d6;
        BinomialAux binomialAux;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = n2 == 0 ? d3 / 2.0 : d3;
        double d10 = Normal.quantile(1.0 - d9);
        if (n2 <= 0) {
            binomialAux = new BinomialAux(d, 4.0 + (double)n);
            d6 = Math.max(d - d10 * Math.sqrt(d * (1.0 - d) / (double)n), 0.0);
            d5 = Math.min(0.01, 1.0 - d6);
            d4 = Solve.search(binomialAux, -d10, d6, d5);
            n3 = (int)Math.floor((double)(n + 4) * d4 - 2.0);
            d8 = Binomial.cdf(n3, n, d2);
            d7 = Binomial.cdf(n3, n, d);
        }
        if (n2 >= 0) {
            binomialAux = new BinomialAux(1.0 - d, 4.0 + (double)n);
            d6 = Math.max(1.0 - d - d10 * Math.sqrt(d * (1.0 - d) / (double)n), 0.0);
            d5 = Math.min(0.01, 1.0 - d6);
            d4 = Solve.search(binomialAux, -d10, d6, d5);
            n3 = (int)Math.floor((double)(n + 4) * d4 - 2.0);
            d8 += Binomial.cdf(n3, n, 1.0 - d2);
            d7 += Binomial.cdf(n3, n, 1.0 - d);
        }
        return new double[]{d8, d7};
    }
}

