/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.dist;

import rvl.stat.dist.Chi2;
import rvl.stat.dist.Normal;
import rvl.util.Utility;

public class Poisson {
    public static double cdf(int n, double d) {
        if (n < 0) {
            return 0.0;
        }
        if (d <= 0.0) {
            Utility.warning("Poisson.cdf: lambda must be positive");
            return Double.NaN;
        }
        return 1.0 - Chi2.cdf(2.0 * d, 2.0 * ((double)n + 1.0));
    }

    public static int quantile(double d, double d2) {
        if (d2 <= 0.0) {
            Utility.warning("Poisson.quantile: lambda must be positive");
            return Integer.MAX_VALUE;
        }
        if (d < 0.0 || d >= 1.0) {
            Utility.warning("Poisson.quantile: alpha must be in [0,1)");
            return Integer.MAX_VALUE;
        }
        if (d == 0.0) {
            return -1;
        }
        int n = (int)(d2 + Normal.quantile(d) * Math.sqrt(d2));
        double d3 = Poisson.cdf(n = Math.max(-1, n), d2);
        if (d3 < d) {
            while ((d3 = Poisson.cdf(++n, d2)) < d - 1.0E-6) {
            }
            --n;
        } else if (d3 > d) {
            while ((d3 = Poisson.cdf(--n, d2)) > d + 1.0E-6) {
            }
        }
        return n;
    }
}

