/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.dist;

import rvl.stat.dist.Normal;
import rvl.util.MoreMath;
import rvl.util.Utility;

public class Tukey {
    static final double M_1_SQRT_2PI = 0.3989422804014327;
    static final double M_LN2 = 0.6931471805599453;

    private static double wprob(double d, double d2, double d3) {
        int n = 12;
        int n2 = 6;
        double d4 = 1.0;
        double d5 = -30.0;
        double d6 = -50.0;
        double d7 = 60.0;
        double d8 = 8.0;
        double d9 = 3.0;
        double d10 = 2.0;
        double d11 = 3.0;
        double[] dArray = new double[]{0.9815606342467192, 0.9041172563704749, 0.7699026741943047, 0.5873179542866175, 0.3678314989981802, 0.1252334085114689};
        double[] dArray2 = new double[]{0.04717533638651183, 0.10693932599531843, 0.16007832854334622, 0.20316742672306592, 0.2334925365383548, 0.24914704581340277};
        double d12 = d * 0.5;
        if (d12 >= d8) {
            return 1.0;
        }
        double d13 = 2.0 * Normal.cdf(d12) - 1.0;
        d13 = d13 >= Math.exp(d6 / d3) ? Math.pow(d13, d3) : 0.0;
        double d14 = d > d9 ? d10 : d11;
        double d15 = d12;
        double d16 = (d8 - d12) / d14;
        double d17 = d15 + d16;
        double d18 = 0.0;
        double d19 = d3 - 1.0;
        for (double d20 = 1.0; d20 <= d14; d20 += 1.0) {
            double d21 = 0.0;
            double d22 = 0.5 * (d17 + d15);
            double d23 = 0.5 * (d17 - d15);
            for (int i = 1; i <= n; ++i) {
                double d24;
                double d25;
                int n3;
                if (n2 < i) {
                    n3 = n - i + 1;
                    d25 = dArray[n3 - 1];
                } else {
                    n3 = i;
                    d25 = -dArray[n3 - 1];
                }
                double d26 = d23 * d25;
                double d27 = d22 + d26;
                double d28 = d27 * d27;
                if (d28 > d7) break;
                double d29 = 2.0 * Normal.cdf(d27);
                double d30 = d29 * 0.5 - (d24 = 2.0 * Normal.cdf(d27, d, 1.0)) * 0.5;
                if (!(d30 >= Math.exp(d5 / d19))) continue;
                d30 = dArray2[n3 - 1] * Math.exp(-(0.5 * d28)) * Math.pow(d30, d19);
                d21 += d30;
            }
            d18 += (d21 *= 2.0 * d23 * d3 * 0.3989422804014327);
            d15 = d17;
            d17 += d16;
        }
        if ((d13 = d18 + d13) <= Math.exp(d5 / d2)) {
            return 0.0;
        }
        if ((d13 = Math.pow(d13, d2)) >= d4) {
            d13 = 1.0;
        }
        return d13;
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        int n = 16;
        int n2 = 8;
        double d5 = -30.0;
        double d6 = 1.0E-14;
        double d7 = 100.0;
        double d8 = 800.0;
        double d9 = 5000.0;
        double d10 = 25000.0;
        double d11 = 1.0;
        double d12 = 0.5;
        double d13 = 0.25;
        double d14 = 0.125;
        double[] dArray = new double[]{0.9894009349916499, 0.9445750230732326, 0.8656312023878318, 0.755404408355003, 0.6178762444026438, 0.45801677765722737, 0.2816035507792589, 0.09501250983763744};
        double[] dArray2 = new double[]{0.027152459411754096, 0.062253523938647894, 0.09515851168249279, 0.12462897125553388, 0.14959598881657674, 0.16915651939500254, 0.18260341504492358, 0.1894506104550685};
        if (Double.isNaN(d) || Double.isNaN(d4) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d <= 0.0) {
            return 0.0;
        }
        if (d3 < 2.0 || d4 < 1.0 || d2 < 2.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return 1.0;
        }
        if (d3 > d10) {
            return Tukey.wprob(d, d4, d2);
        }
        double d15 = d3 * 0.5;
        double d16 = d15 * Math.log(d3) - d3 * 0.6931471805599453 - MoreMath.logGamma(d15);
        double d17 = d15 - 1.0;
        double d18 = d3 * 0.25;
        double d19 = d3 <= d7 ? d11 : (d3 <= d8 ? d12 : (d3 <= d9 ? d13 : d14));
        d16 += Math.log(d19);
        double d20 = 0.0;
        double d21 = 0.0;
        for (int i = 1; i <= 50; ++i) {
            d20 = 0.0;
            double d22 = (double)(2 * i - 1) * d19;
            for (int j = 1; j <= n; ++j) {
                double d23;
                int n3;
                if (n2 < j) {
                    n3 = j - n2 - 1;
                    d23 = d16 + d17 * Math.log(d22 + dArray[n3] * d19) - (dArray[n3] * d19 + d22) * d18;
                } else {
                    n3 = j - 1;
                    d23 = d16 + d17 * Math.log(d22 - dArray[n3] * d19) + (dArray[n3] * d19 - d22) * d18;
                }
                if (!(d23 >= d5)) continue;
                double d24 = n2 < j ? d * Math.sqrt((dArray[n3] * d19 + d22) * 0.5) : d * Math.sqrt((-(dArray[n3] * d19) + d22) * 0.5);
                double d25 = Tukey.wprob(d24, d4, d2);
                double d26 = d25 * dArray2[n3] * Math.exp(d23);
                d20 += d26;
            }
            if ((double)i * d19 >= 1.0 && d20 <= d6) break;
            d21 += d20;
        }
        if (d20 > d6) {
            return Utility.NaN("Tukey.cdf: failed to converge");
        }
        if (d21 > 1.0) {
            d21 = 1.0;
        }
        return d21;
    }

    public static double cdf(double d, double d2, double d3) {
        return Tukey.cdf(d, d2, d3, 1.0);
    }

    private static double qinv(double d, double d2, double d3) {
        double d4 = 0.322232421088;
        double d5 = 0.099348462606;
        double d6 = -1.0;
        double d7 = 0.588581570495;
        double d8 = -0.342242088547;
        double d9 = 0.531103462366;
        double d10 = -0.204231210125;
        double d11 = 0.10353775285;
        double d12 = -4.53642210148E-5;
        double d13 = 0.0038560700634;
        double d14 = 0.8832;
        double d15 = 0.2368;
        double d16 = 1.214;
        double d17 = 1.208;
        double d18 = 1.4142;
        double d19 = 120.0;
        double d20 = 0.5 - 0.5 * d;
        double d21 = Math.sqrt(Math.log(1.0 / (d20 * d20)));
        double d22 = d21 + ((((d21 * d12 + d10) * d21 + d8) * d21 + d6) * d21 + d4) / ((((d21 * d13 + d11) * d21 + d9) * d21 + d7) * d21 + d5);
        if (d3 < d19) {
            d22 += (d22 * d22 * d22 + d22) / d3 / 4.0;
        }
        double d23 = d14 - d15 * d22;
        if (d3 < d19) {
            d23 += -d16 / d3 + d17 * d22 / d3;
        }
        return d22 * (d23 * Math.log(d2 - 1.0) + d18);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        double d5 = 1.0E-4;
        int n = 50;
        double d6 = 0.0;
        if (Double.isNaN(d) || Double.isNaN(d4) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d < 0.0 || d >= 1.0) {
            return Double.NaN;
        }
        if (d3 < 2.0 || d4 < 1.0 || d2 < 2.0) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d7 = Tukey.qinv(d, d2, d3);
        double d8 = Tukey.cdf(d7, d2, d3, d4) - d;
        double d9 = d8 > 0.0 ? Math.max(0.0, d7 - 1.0) : d7 + 1.0;
        double d10 = Tukey.cdf(d9, d2, d3, d4) - d;
        for (int i = 1; i < n; ++i) {
            d6 = d9 - d10 * (d9 - d7) / (d10 - d8);
            d8 = d10;
            d7 = d9;
            if (d6 < 0.0) {
                d6 = 0.0;
                d10 = -d;
            }
            d10 = Tukey.cdf(d6, d2, d3, d4) - d;
            d9 = d6;
            double d11 = Math.abs(d9 - d7);
            if (!(d11 < d5)) continue;
            return d6;
        }
        Utility.warning("Tukey.quantile(): failed to converge");
        return d6;
    }

    public static double quantile(double d, double d2, double d3) {
        return Tukey.quantile(d, d2, d3, 1.0);
    }

    public static void main(String[] stringArray) {
        double d = Tukey.quantile(0.95, 5.0, 20.0);
        System.out.println("q = " + d);
        System.out.println("p = " + Tukey.cdf(d, 5.0, 20.0));
    }
}

