/*
 * Decompiled with CFR 0.152.
 */
package rvl.util;

public class RNG {
    private double theSeed = 0.123456789;
    private double theMult = 63069.0;
    private double theTerm = 0.84763521;
    private boolean flag = true;
    private double u1;
    private double u2;
    private double r;

    public RNG() {
        this.theSeed = (double)(System.currentTimeMillis() & 0xFFFFL) / 65536.0;
    }

    public RNG(double d) {
        this.setSeed(d);
    }

    public void setSeed(double d) {
        this.theSeed = Math.abs(d);
    }

    public void setMult(double d) {
        this.theMult = d;
    }

    public void setTerm(double d) {
        this.theTerm = d;
    }

    public double getSeed() {
        return this.theSeed;
    }

    public double getMult() {
        return this.theMult;
    }

    public double getTerm() {
        return this.theTerm;
    }

    public double unif() {
        double d = this.theMult * this.theSeed + this.theTerm;
        this.theSeed = d - Math.floor(d);
        return this.theSeed;
    }

    public synchronized double norm() {
        boolean bl = this.flag = !this.flag;
        if (this.flag) {
            return this.r * this.u2;
        }
        do {
            this.u1 = 2.0 * this.unif() - 1.0;
            this.u2 = 2.0 * this.unif() - 1.0;
            this.r = this.u1 * this.u1 + this.u2 * this.u2;
        } while (this.r >= 1.0);
        this.r = Math.sqrt(-2.0 * Math.log(this.r) / this.r);
        return this.r * this.u1;
    }

    public static void main(String[] stringArray) {
        RNG rNG = new RNG();
        RNG rNG2 = new RNG(rNG.getSeed() + 1.0E-15);
        RNG rNG3 = new RNG(rNG.getSeed() + 0.6417946);
        for (int i = 0; i < 20; ++i) {
            System.out.println(rNG.unif() + "\t" + rNG2.unif() + "\t" + rNG3.norm());
        }
    }
}

