/*
 * Decompiled with CFR 0.152.
 */
package rvl.util;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import rvl.awt.ViewWindow;
import rvl.util.Closeable;
import rvl.util.ModelessMsgBox;

public class Utility
implements Closeable {
    private static ViewWindow msgWindow = null;
    private static boolean guiWarn = false;
    private static final double[] nice_d = new double[]{2.0, 2.5, 2.0};

    public static double NaN(String string) {
        Utility.warning(string);
        return Double.NaN;
    }

    public void close() {
        Utility.exit(1);
    }

    public static void error(String string) {
        Utility.error(string, null);
    }

    public static void error(String string, Closeable closeable) {
        Utility.warning(string);
        if (guiWarn) {
            new ModelessMsgBox("Fatal error", "See warning/error window", new Utility());
        } else {
            if (closeable != null) {
                closeable.close();
            }
            Utility.exit(1);
        }
    }

    public static void error(Throwable throwable) {
        Utility.error(throwable, null);
    }

    public static void error(Throwable throwable, Closeable closeable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        Utility.error(byteArrayOutputStream.toString(), closeable);
    }

    public static void exit(int n) {
        try {
            System.exit(n);
        }
        catch (SecurityException securityException) {
            Utility.warning("You may need to close some windows manually");
        }
    }

    public static String fixedFormat(double d, int n) {
        double d2 = Math.pow(10.0, n);
        int n2 = Math.round((float)(d * d2));
        String string = String.valueOf(n2);
        if (n == 0) {
            return string;
        }
        if (n > 0) {
            int n3 = string.length();
            while (n3 <= n) {
                string = "0" + string;
                ++n3;
            }
            int n4 = string.length() - n;
            return String.valueOf(string.substring(0, n4)) + "." + string.substring(n4);
        }
        return String.valueOf((int)((double)n2 / d2 + 0.01));
    }

    public static String[] fmtNice(double[] dArray) {
        if (dArray.length < 2) {
            return new String[]{String.valueOf(dArray)};
        }
        double d = 0.1 * Math.abs(dArray[1] - dArray[0]);
        if (dArray[0] == dArray[1]) {
            d = Math.max(1.0, Math.abs(dArray[0]));
        }
        String[] stringArray = new String[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            stringArray[n] = Utility.minFormat(dArray[n], d);
            ++n;
        }
        return stringArray;
    }

    public static String format(double d, int n) {
        return Utility.format(d, n, true);
    }

    public static String format(double d, int n, boolean bl) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return String.valueOf(d);
        }
        if (d < 0.0) {
            return "-" + Utility.format(-d, n, bl);
        }
        if (n <= 0) {
            return Utility.fixedFormat(d, -n);
        }
        if (d == 0.0) {
            return "0";
        }
        n = Math.min(n, 15);
        int n2 = (int)((double)n - Math.floor(Math.log(d) / Math.log(10.0)) - 1.0);
        long l = (long)Math.floor(d * Math.pow(10.0, n2) + 0.5);
        String string = new Long(l).toString();
        int n3 = string.length();
        int n4 = n3 - n2;
        if (bl) {
            while (string.charAt(n3 - 1) == '0') {
                --n3;
                --n2;
            }
            string = string.substring(0, n3);
        }
        if (n2 <= 0) {
            if (n2 < -3) {
                return Utility.sciFormat(string, n4 - 1);
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            int n5 = 0;
            while (n5 < -n2) {
                stringBuffer.append("0");
                ++n5;
            }
            return new String(stringBuffer);
        }
        if (n4 >= 0) {
            return String.valueOf(string.substring(0, n4)) + "." + string.substring(n4);
        }
        if (n4 < -3) {
            return Utility.sciFormat(string, n4 - 1);
        }
        StringBuffer stringBuffer = new StringBuffer(".");
        int n6 = 0;
        while (n6 < -n4) {
            stringBuffer.append("0");
            ++n6;
        }
        stringBuffer.append(string);
        return new String(stringBuffer);
    }

    public static String format(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n - 1);
        }
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        stringBuffer.append(string);
        while (stringBuffer.length() < n) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            Utility.testTicks(-7.99, 3.99, 4, true);
            Utility.testTicks(-799.0, 399.0, 4, true);
            Utility.testTicks(-0.00799, 0.00399, 4, true);
            Utility.testTicks(-7.99E10, 3.99E10, 4, true);
            Utility.testTicks(-7.99E-10, 3.99E-10, 4, true);
        } else {
            Utility.testTicks(Utility.strtod(stringArray[0]), Utility.strtod(stringArray[1]), Utility.strtoi(stringArray[2]), stringArray[3].equals("true"));
        }
    }

    public static String minFormat(double d, double d2) {
        if (d == 0.0) {
            return "0";
        }
        int n = 1;
        while (true) {
            String string = Utility.format(d, n);
            Double d3 = new Double(string);
            if (Math.abs(d3 - d) < d2) {
                return string;
            }
            ++n;
        }
    }

    private static int nTicks(double d, double d2, double d3, double d4) {
        int n = 0;
        double d5 = d3;
        while (d5 <= d2) {
            ++n;
            d5 += d4;
        }
        double d6 = d3 - d4;
        while (d6 >= d) {
            ++n;
            d6 -= d4;
        }
        return n;
    }

    public static double[] nice(double d, double d2, int n, boolean bl) {
        if (d > d2) {
            return Utility.nice(d2, d, n, bl);
        }
        if (d2 <= 0.0) {
            double[] dArray = Utility.nice(-d2, -d, n, bl);
            int n2 = 0;
            while (n2 < dArray.length) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] * -1.0;
            }
            return dArray;
        }
        if (d == d2) {
            if (d2 == 0.0) {
                return new double[]{-1.0, 1.0};
            }
            d2 *= 1.1;
        }
        double d3 = 0.005 * (d2 - d);
        if (!bl) {
            d -= d3;
            d2 += d3;
        } else {
            d += d3;
            d2 -= d3;
            n -= 2;
        }
        d3 *= 2.0;
        double d4 = 0.0;
        double d5 = Math.floor(Math.log(d2) / Math.log(10.0));
        double d6 = Math.pow(10.0, d5);
        if (d * d2 > 0.0) {
            while (d4 + d3 < d) {
                d4 = d6 * (double)((int)(d2 / d6));
                d6 /= 10.0;
            }
        }
        d6 *= 10.0;
        int n4 = 0;
        while (Utility.nTicks(d, d2, d4, d6) < n) {
            d6 /= nice_d[n4];
            n4 = (n4 + 1) % 3;
        }
        int n5 = Utility.nTicks(d, d2, d4, d6);
        while (d4 - d6 >= d) {
            d4 -= d6;
        }
        if (bl) {
            if (Math.abs(d - d4) / d6 > 0.05) {
                d4 -= d6;
                ++n5;
            }
            if (Math.abs(d4 + (double)(n5 - 1) * d6 - d2) / d6 > 0.05) {
                ++n5;
            }
        }
        double[] dArray = new double[n5];
        int n6 = 0;
        while (n6 < n5) {
            dArray[n6] = d4 + (double)n6 * d6;
            ++n6;
        }
        return dArray;
    }

    public static int[] order(double[] dArray) {
        int[] nArray = new int[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            nArray[n] = n;
            ++n;
        }
        Utility.order(nArray, dArray, 0, dArray.length - 1);
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    protected static void order(int[] var0, double[] var1_1, int var2_2, int var3_3) {
        var4_4 = var2_2;
        var5_5 = var3_3;
        var6_6 = var1_1[var0[(var4_4 + var5_5) / 2]];
        ** GOTO lbl17
        {
            ++var4_4;
            do {
                if (var4_4 < var3_3 && var1_1[var0[var4_4]] < var6_6) continue block0;
                while (var5_5 > var2_2 && var1_1[var0[var5_5]] > var6_6) {
                    --var5_5;
                }
                if (var4_4 > var5_5) continue;
                var8_7 = var0[var4_4];
                var0[var4_4] = var0[var5_5];
                var0[var5_5] = var8_7;
                ++var4_4;
                --var5_5;
lbl17:
                // 3 sources

            } while (var4_4 <= var5_5);
        }
        if (var2_2 < var5_5) {
            Utility.order(var0, var1_1, var2_2, var5_5);
        }
        if (var4_4 < var3_3) {
            Utility.order(var0, var1_1, var4_4, var3_3);
        }
    }

    public static double[] parseDoubles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = Utility.strtod(stringTokenizer.nextToken());
            ++n2;
        }
        return dArray;
    }

    public static void qsort(double[] dArray) {
        Utility.qsort(dArray, 0, dArray.length - 1);
    }

    /*
     * Unable to fully structure code
     */
    protected static void qsort(double[] var0, int var1_1, int var2_2) {
        var3_3 = var1_1;
        var4_4 = var2_2;
        var5_5 = var0[(var3_3 + var4_4) / 2];
        ** GOTO lbl17
        {
            ++var3_3;
            do {
                if (var3_3 < var2_2 && var0[var3_3] < var5_5) continue block0;
                while (var4_4 > var1_1 && var0[var4_4] > var5_5) {
                    --var4_4;
                }
                if (var3_3 > var4_4) continue;
                var7_6 = var0[var3_3];
                var0[var3_3] = var0[var4_4];
                var0[var4_4] = var7_6;
                ++var3_3;
                --var4_4;
lbl17:
                // 3 sources

            } while (var3_3 <= var4_4);
        }
        if (var1_1 < var4_4) {
            Utility.qsort(var0, var1_1, var4_4);
        }
        if (var3_3 < var2_2) {
            Utility.qsort(var0, var3_3, var2_2);
        }
    }

    public static int[] rank(double[] dArray) {
        int[] nArray = Utility.order(dArray);
        int n = dArray.length;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[nArray[n2]] = n2 + 1;
            ++n2;
        }
        return nArray2;
    }

    public static float[] rankTies(double[] dArray) {
        int[] nArray = Utility.order(dArray);
        int n = dArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[nArray[n2]];
            int n3 = n2 + 1;
            while (n3 < n && dArray[nArray[n3]] == d) {
                ++n3;
            }
            int n4 = n2;
            while (n4 < n3) {
                fArray[nArray[n4]] = 0.5f * (float)(n2 + n3 + 1);
                ++n4;
            }
            n2 = n3;
        }
        return fArray;
    }

    private static String sciFormat(String string, int n) {
        if (string.length() == 1) {
            return String.valueOf(string) + "e" + n;
        }
        return String.valueOf(string.substring(0, 1)) + "." + string.substring(1) + "e" + n;
    }

    public static void setGUIWarn(boolean bl) {
        guiWarn = bl;
    }

    public static double strtod(String string) {
        try {
            return Double.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static float strtof(String string) {
        try {
            return Float.valueOf(string.trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return Float.NaN;
        }
    }

    public static int strtoi(String string) {
        try {
            return Integer.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    public static long strtol(String string) {
        try {
            return Long.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return Long.MAX_VALUE;
        }
    }

    private static void testTicks(double d, double d2, int n, boolean bl) {
        System.out.println("\n a=" + d + ", b=" + d2 + ", minTicks=" + n + ", enclose=" + bl);
        double[] dArray = Utility.nice(d, d2, n, bl);
        String[] stringArray = Utility.fmtNice(dArray);
        int n2 = 0;
        while (n2 < dArray.length) {
            System.out.println(stringArray[n2]);
            ++n2;
        }
    }

    public static void warning(String string) {
        if (!guiWarn) {
            System.err.println(string);
            return;
        }
        if (msgWindow == null) {
            msgWindow = new ViewWindow("Errors and warnings", 25, 60);
            msgWindow.setClearButton(true);
        }
        msgWindow.append(String.valueOf(string) + "\n");
        if (!msgWindow.isVisible()) {
            ((Component)msgWindow).setVisible(true);
            msgWindow.show();
        }
    }

    public static void warning(Throwable throwable) {
        Utility.warning(throwable, false);
    }

    public static void warning(Throwable throwable, boolean bl) {
        if (bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
            Utility.warning(byteArrayOutputStream.toString());
        } else {
            Utility.warning(throwable.toString());
        }
    }
}

